/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.rep.RAssoKey;
import com.ibm.hsc.rep.RAssoObject;
import com.ibm.hsc.rep.RAssoSchema;
import com.ibm.hsc.rep.RCimWrapper;
import com.ibm.hsc.rep.RClassSchema;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.RUtils;
import com.ibm.hsc.rep.serialization.RSerializableInterface;
import com.ibm.hsc.rep.serialization.RSerializableObject;
import com.ibm.hsc.rep.serialization.RSerializableProperty;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;

public class RObject
implements Cloneable,
RSerializableInterface {
    private int m_nsid;
    private RObjectId m_oid = null;
    private Object[] m_prop;
    private Vector[] m_link;
    private RClassSchema m_schema;

    public RObject() {
    }

    public RObject(String string, CIMInstance cIMInstance) throws CIMException {
        Vector vector = cIMInstance.getProperties();
        try {
            this.m_nsid = RUtils.getNameSpaceId(string);
            this.m_schema = RUtils.getClassSchema(this.m_nsid, RUtils.getClassId(this.m_nsid, cIMInstance.getClassName()));
            this.m_prop = new Object[this.m_schema.getNumOfProps()];
            this.m_link = new Vector[this.m_schema.getNumOfLinks()];
            int n = 0;
            while (n < vector.size()) {
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
                RUtils.validateDataType(cIMProperty);
                Object object = RCimWrapper.getRValue(cIMProperty);
                this.setProperty(cIMProperty.getName(), object);
                ++n;
            }
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        if (vector.size() != this.m_schema.getNumOfProps()) {
            System.out.println("[TX-REP]the number of properties of this HSC repository object does not match what it is defined in the MOF");
            System.out.println("[TX-REP]size of props in repository = " + this.getSchema().getNumOfProps());
            System.out.println("[TX-REP]size of props in MOF = " + vector.size());
            System.out.println("[TX-REP]cimInst = " + cIMInstance);
            HSCCIMException hSCCIMException = new HSCCIMException("CIM_ERR_TYPE_MISMATCH");
            hSCCIMException.printStackTrace();
            throw hSCCIMException;
        }
    }

    public RObject(int n, int n2) throws RException {
        this.m_nsid = n;
        this.m_schema = RUtils.getClassSchema(n, n2);
        this.m_prop = new Object[this.m_schema.getNumOfProps()];
        this.m_link = new Vector[this.m_schema.getNumOfLinks()];
    }

    public RObject(int n, RClassSchema rClassSchema) {
        this.m_nsid = n;
        this.m_schema = rClassSchema;
        this.m_prop = new Object[this.m_schema.getNumOfProps()];
        this.m_link = new Vector[this.m_schema.getNumOfLinks()];
    }

    public RObject(RObjectId rObjectId) throws RException {
        this.m_nsid = rObjectId.getNameSpaceId();
        int n = rObjectId.getClassId();
        this.m_schema = RUtils.getClassSchema(this.m_nsid, n);
        this.m_prop = new Object[this.m_schema.getNumOfProps()];
        this.m_link = new Vector[this.m_schema.getNumOfLinks()];
        int n2 = rObjectId.getNumOfKeys();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.m_schema.getKeyPos(n3);
            this.setProperty(n4, rObjectId.getKeyValue(n3));
            ++n3;
        }
    }

    public void loadObject(RSerializableObject rSerializableObject) throws ObjectStreamException {
        try {
            Vector vector = (Vector)rSerializableObject.getObject();
            int n = vector.size();
            this.m_nsid = RUtils.getNameSpaceId((String)vector.elementAt(0));
            int n2 = RUtils.getClassId(this.m_nsid, (String)vector.elementAt(1));
            this.m_schema = RUtils.getClassSchema(this.m_nsid, n2);
            this.m_prop = new Object[this.m_schema.getNumOfProps()];
            this.m_link = new Vector[this.m_schema.getNumOfLinks()];
            int n3 = 2;
            while (n3 < n) {
                RSerializableProperty rSerializableProperty = (RSerializableProperty)vector.elementAt(n3);
                int n4 = this.m_schema.getIndex(rSerializableProperty.getName());
                this.m_prop[n4] = rSerializableProperty.getRValue();
                ++n3;
            }
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new InvalidObjectException(rException.getID());
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        try {
            Serializable serializable;
            String string = "com.ibm.hsc.rep.client.RClientObject";
            Vector<Object> vector = new Vector<Object>();
            vector.add(RUtils.getNameSpaceString(this.m_nsid));
            vector.add(this.m_schema.getClassName());
            int n = 0;
            while (n < this.m_schema.getNumOfProps()) {
                serializable = new RSerializableProperty(this.m_schema.isKey(n), this.m_schema.getPropName(n), this.m_prop[n]);
                vector.add(serializable);
                ++n;
            }
            serializable = new RSerializableObject(string, null, vector);
            return serializable;
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new InvalidObjectException(rException.getID());
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        RObject rObject = (RObject)object;
        rObject.m_prop = (Object[])this.m_prop.clone();
        int n = 0;
        while (n < this.m_prop.length) {
            if (this.m_prop[n] != null) {
                if (this.m_prop[n] instanceof Vector) {
                    rObject.m_prop[n] = ((Vector)this.m_prop[n]).clone();
                } else {
                    Class<?> clazz = this.m_prop[n].getClass();
                    if (clazz.isArray()) {
                        rObject.m_prop[n] = ((Object[])this.m_prop[n]).clone();
                    }
                }
            }
            ++n;
        }
        rObject.m_link = (Vector[])this.m_link.clone();
        int n2 = 0;
        while (n2 < this.m_link.length) {
            if (this.m_link[n2] != null) {
                rObject.m_link[n2] = (Vector)this.m_link[n2].clone();
                Vector vector = rObject.m_link[n2];
                int n3 = 0;
                while (n3 < vector.size()) {
                    RObjectId rObjectId = (RObjectId)vector.elementAt(n3);
                    vector.setElementAt(rObjectId.clone(), n3);
                    ++n3;
                }
            }
            ++n2;
        }
        return rObject;
    }

    public RClassSchema getSchema() {
        return this.m_schema;
    }

    public int getNameSpaceId() {
        return this.m_nsid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("instance of ");
        stringBuffer.append(this.m_schema.getClassName());
        stringBuffer.append(" {\n");
        int n = this.m_schema.getNumOfProps();
        int n2 = 0;
        while (n2 < n) {
            String string = this.m_schema.getPropName(n2);
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            if (this.m_prop[n2] instanceof Object[]) {
                Object[] objectArray = (Object[])this.m_prop[n2];
                if (objectArray != null) {
                    Vector<Object> vector = new Vector<Object>();
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        vector.add(objectArray[n3]);
                        ++n3;
                    }
                    stringBuffer.append(vector);
                } else {
                    stringBuffer.append("null");
                }
            } else {
                stringBuffer.append(this.m_prop[n2]);
            }
            stringBuffer.append(";\n");
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public int getClassId() {
        return this.m_schema.getClassId();
    }

    public boolean setProperty(int n, Object object) throws RException {
        if (n < this.m_schema.getNumOfProps() && n >= 0) {
            if (this.m_prop[n] != object) {
                this.m_prop[n] = object;
                return true;
            }
            return false;
        }
        throw new RException("R_ERR_NOT_FOUND");
    }

    public Object getProperty(int n) throws RException {
        if (n < this.m_schema.getNumOfProps() && n >= 0) {
            return this.m_prop[n];
        }
        throw new RException("R_ERR_NOT_FOUND");
    }

    public boolean setProperty(String string, Object object) throws RException {
        int n = this.m_schema.getIndex(string);
        return this.setProperty(n, object);
    }

    public Object getProperty(String string) throws RException {
        return this.getProperty(this.m_schema.getIndex(string));
    }

    public RObjectId getObjectId() throws RException {
        if (this.m_oid == null) {
            this.m_oid = new RObjectId(this.m_nsid, this.m_schema.getClassId());
            int n = 0;
            while (n < this.m_schema.getNumOfKeys()) {
                Object object = this.getProperty(this.m_schema.getKeyPos(n));
                if (object == null) {
                    throw new RException("R_ERR_KEY_PROPERTY_NULL");
                }
                this.m_oid.setKeyValue(n, object);
                ++n;
            }
        }
        return this.m_oid;
    }

    public void setInstance() throws RException {
        RObjectId rObjectId = this.getObjectId();
        RObject rObject = (RObject)this.m_schema.getObjHash().get(rObjectId);
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        this.m_schema.getObjHash().put(rObjectId, this);
    }

    public void addInstance() throws RException {
        RObjectId rObjectId = this.getObjectId();
        Hashtable hashtable = this.m_schema.getObjHash();
        RObject rObject = (RObject)hashtable.get(rObjectId);
        if (rObject != null) {
            throw new RException("R_ERR_ALREADY_EXISTS");
        }
        hashtable.put(rObjectId, this);
    }

    public void deleteInstance() throws RException {
        this.m_schema.getObjHash().remove(this.getObjectId());
        int n = this.m_schema.getLinkBase();
        int n2 = this.m_schema.getNumOfLinks();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n + n3;
            int n5 = this.m_schema.getAssoId(n4);
            RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n5);
            if (this.m_link[n3] != null) {
                int n6 = 0;
                while (n6 < this.m_link[n3].size()) {
                    RObjectId rObjectId;
                    RObjectId rObjectId2;
                    int n7;
                    RObjectId rObjectId3 = (RObjectId)this.m_link[n3].elementAt(n6);
                    RObject rObject = rObjectId3.getObject();
                    if (n4 == rAssoSchema.getRef1LinkId()) {
                        n7 = rAssoSchema.getRef2LinkId();
                        rObjectId2 = this.getObjectId();
                        rObjectId = rObjectId3;
                    } else {
                        n7 = rAssoSchema.getRef1LinkId();
                        rObjectId2 = rObjectId3;
                        rObjectId = this.getObjectId();
                    }
                    if (rObject != null) {
                        System.out.println("[TX-REP]delete asso " + rAssoSchema.getClassName());
                        rObject.removeLink(n7, this.getObjectId());
                    }
                    if (rAssoSchema.hasProperty()) {
                        RAssoKey rAssoKey = new RAssoKey(this.m_nsid, n5, rObjectId2, rObjectId);
                        Hashtable hashtable = rAssoSchema.getAssoPropHash();
                        Hashtable hashtable2 = RAssoSchema.getAssoObjHash();
                        hashtable2.remove(rAssoKey);
                    }
                    ++n6;
                }
            }
            ++n3;
        }
    }

    protected Vector enumLinks(int n) throws RException {
        int n2 = this.m_schema.getLinkBase();
        int n3 = this.m_schema.getNumOfLinks();
        if (n < n2 || n >= n2 + n3) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        return this.m_link[n - n2];
    }

    public Vector associatorNames(int n) throws RException {
        int n2 = this.getLinkId(n);
        return this.associatorNamesByLink(n2);
    }

    public Vector associatorNamesByLink(int n) throws RException {
        Vector vector = this.enumLinks(n);
        if (vector != null) {
            vector = (Vector)vector.clone();
            int n2 = 0;
            while (n2 < vector.size()) {
                RObjectId rObjectId = (RObjectId)vector.elementAt(n2);
                vector.setElementAt(rObjectId.clone(), n2);
                ++n2;
            }
        }
        return vector;
    }

    private int getLinkId(int n) throws RException {
        int n2;
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n);
        int n3 = rAssoSchema.getRef1ClassId();
        if (n3 == (n2 = rAssoSchema.getRef2ClassId())) {
            System.out.println("[TX-REP]Bug: RObject:getLinkId failed");
            System.out.println("[TX-REP]link ID for aid " + n + " is not unique.");
            throw new RException("R_ERR_FAILED");
        }
        int n4 = this.m_schema.getClassId();
        int n5 = -1;
        if (n4 == n3) {
            n5 = rAssoSchema.getRef1LinkId();
        } else if (n4 == n2) {
            n5 = rAssoSchema.getRef2LinkId();
        }
        if (n5 < 0) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        return n5;
    }

    public Vector associators(int n) throws RException {
        int n2 = this.getLinkId(n);
        return this.associatorsByLink(n2);
    }

    public Vector associatorsByLink(int n) throws RException {
        Vector vector = this.enumLinks(n);
        Vector<Object> vector2 = null;
        if (vector != null) {
            vector2 = new Vector<Object>();
            int n2 = 0;
            while (n2 < vector.size()) {
                RObjectId rObjectId = (RObjectId)vector.elementAt(n2);
                RObject rObject = rObjectId.getObject();
                if (rObject != null) {
                    vector2.add(rObject.clone());
                }
                ++n2;
            }
        }
        return vector2;
    }

    public void addAssociation(int n, RObjectId rObjectId) throws RException {
        int n2 = this.getLinkId(n);
        RObject rObject = rObjectId.getObject();
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        this.addLink(n2, rObjectId);
        int n3 = rObject.getLinkId(n);
        rObject.addLink(n3, this.getObjectId());
    }

    public void addAssociationByLink(int n, RObjectId rObjectId) throws RException {
        int n2 = this.m_schema.getAssoId(n);
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n2);
        int n3 = rAssoSchema.getRef1LinkId();
        int n4 = rAssoSchema.getRef2LinkId();
        int n5 = -1;
        if (n == n3) {
            n5 = n4;
        } else if (n == n4) {
            n5 = n3;
        } else {
            throw new RException("R_ERR_FAILED");
        }
        RObject rObject = rObjectId.getObject();
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        this.addLink(n, rObjectId);
        rObject.addLink(n5, this.getObjectId());
    }

    public void addAsso(int n, RObjectId rObjectId) throws RException {
        this.addAssociation(n, rObjectId);
    }

    public boolean hasAssociation(int n, RObjectId rObjectId) throws RException {
        int n2 = this.getLinkId(n);
        RObject rObject = rObjectId.getObject();
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        boolean bl = this.hasLink(n2, rObjectId);
        int n3 = rObject.getLinkId(n);
        boolean bl2 = rObject.hasLink(n3, this.getObjectId());
        if (bl && bl2) {
            return true;
        }
        if (bl || bl2) {
            System.out.println("[TX-REP]Association lost one link");
            throw new RException("R_ERR_FAILED");
        }
        return false;
    }

    public boolean hasAssociationByLink(int n, RObjectId rObjectId) throws RException {
        RObject rObject;
        int n2 = this.m_schema.getAssoId(n);
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n2);
        int n3 = rAssoSchema.getRef1LinkId();
        int n4 = rAssoSchema.getRef2LinkId();
        int n5 = -1;
        if (n == n3) {
            n5 = n4;
        } else if (n == n4) {
            n5 = n3;
        } else {
            throw new RException("R_ERR_FAILED");
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.hasLink(n, rObjectId)) {
            bl = true;
        }
        if ((rObject = rObjectId.getObject()) == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        if (rObject.hasLink(n5, this.getObjectId())) {
            bl2 = true;
        }
        if (bl && bl2) {
            return true;
        }
        if (!bl && !bl2) {
            return false;
        }
        System.out.println("[TX-REP] Bug: missing link in association.");
        throw new RException("R_ERR_FAILED");
    }

    public void deleteAssociation(int n, RObjectId rObjectId) throws RException {
        int n2 = this.getLinkId(n);
        this.removeLink(n2, rObjectId);
        RObject rObject = rObjectId.getObject();
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        int n3 = rObject.getLinkId(n);
        rObject.removeLink(n3, this.getObjectId());
    }

    public void deleteAssociationByLink(int n, RObjectId rObjectId) throws RException {
        int n2 = this.m_schema.getAssoId(n);
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n2);
        int n3 = rAssoSchema.getRef1LinkId();
        int n4 = rAssoSchema.getRef2LinkId();
        int n5 = -1;
        if (n == n3) {
            n5 = n4;
        } else if (n == n4) {
            n5 = n3;
        } else {
            throw new RException("R_ERR_FAILED");
        }
        this.removeLink(n, rObjectId);
        RObject rObject = rObjectId.getObject();
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        rObject.removeLink(n5, this.getObjectId());
    }

    protected boolean hasLink(int n, RObjectId rObjectId) throws RException {
        int n2 = this.m_schema.getLinkBase();
        int n3 = this.m_schema.getNumOfLinks();
        if (n < n2 || n >= n2 + n3) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        return this.m_link[n - n2] != null && this.m_link[n - n2].contains(rObjectId);
    }

    protected void addLink(int n, RObjectId rObjectId) throws RException {
        int n2 = this.m_schema.getLinkBase();
        int n3 = this.m_schema.getNumOfLinks();
        if (n < n2 || n >= n2 + n3) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        if (this.m_link[n - n2] == null) {
            this.m_link[n - n2] = new Vector();
        } else if (this.m_link[n - n2].contains(rObjectId)) {
            throw new RException("R_ERR_ALREADY_EXISTS");
        }
        this.m_link[n - n2].add(rObjectId);
    }

    protected void removeLink(int n, RObjectId rObjectId) throws RException {
        int n2 = this.m_schema.getLinkBase();
        int n3 = this.m_schema.getNumOfLinks();
        if (n < n2 || n >= n2 + n3) {
            System.out.println("[TX-REP]linkId=" + n);
            System.out.println("[TX-REP]linkBase=" + n2);
            System.out.println("[TX-REP]numOfLinks=" + n3);
            throw new RException("R_ERR_NOT_FOUND");
        }
        if (this.m_link[n - n2] == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        if (!this.m_link[n - n2].contains(rObjectId)) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        this.m_link[n - n2].remove(rObjectId);
    }

    public CIMObjectPath cimGetCIMObjectPath(CIMOMHandle cIMOMHandle) throws CIMException {
        CIMObjectPath cIMObjectPath = null;
        try {
            String string = RUtils.getNameSpaceString(this.m_nsid);
            cIMObjectPath = new CIMObjectPath(this.m_schema.getClassName(), string);
            CIMClass cIMClass = ((ProviderCIMOMHandle)cIMOMHandle).getClass(cIMObjectPath, false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMObjectPath = new CIMObjectPath(this.m_schema.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath.setNameSpace(string);
            Vector vector = cIMObjectPath.getKeys();
            this.cimUpdateProperties(vector);
        }
        catch (RException rException) {
            System.out.println("[TX-REP]cimGetCIMObjectPath: class name=" + this.m_schema.getClassName());
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        return cIMObjectPath;
    }

    public CIMInstance cimGetInstance(CIMOMHandle cIMOMHandle) throws CIMException {
        CIMInstance cIMInstance = null;
        try {
            String string = RUtils.getNameSpaceString(this.m_nsid);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(this.m_schema.getClassName(), string);
            CIMClass cIMClass = cIMOMHandle.getClass(cIMObjectPath, false);
            cIMInstance = cIMClass.newInstance();
            Vector vector = cIMInstance.getProperties();
            this.cimUpdateProperties(vector);
        }
        catch (RException rException) {
            System.out.println("[TX-REP]cimGetInstance: class name=" + this.m_schema.getClassName());
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        return cIMInstance;
    }

    public void cimUpdateProperties(Vector vector) throws CIMException {
        int n = 0;
        while (n < vector.size()) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
            String string = cIMProperty.getName();
            CIMDataType cIMDataType = cIMProperty.getType();
            Object object = null;
            try {
                object = this.getProperty(string);
            }
            catch (RException rException) {
                throw new HSCCIMException(rException.getID());
            }
            Object object2 = RCimWrapper.getCValue(cIMDataType, object, string);
            CIMValue cIMValue = null;
            if (object2 != null) {
                cIMValue = new CIMValue(object2, cIMDataType);
            }
            cIMProperty.setValue(cIMValue);
            ++n;
        }
    }

    public void cimSetInstance(CIMOMHandle cIMOMHandle, CIMInstance cIMInstance) throws CIMException {
        Vector vector = cIMInstance.getProperties();
        int n = 0;
        while (n < vector.size()) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
            RUtils.validateDataType(cIMProperty);
            try {
                Object object = RCimWrapper.getRValue(cIMProperty);
                this.setProperty(cIMProperty.getName(), object);
            }
            catch (RException rException) {
                rException.printStackTrace();
                throw new HSCCIMException(rException.getID());
            }
            ++n;
        }
        if (vector.size() != this.getSchema().getNumOfProps()) {
            System.out.println("[TX-REP]the number of properties of this HSC repository object does not match what it is defined in the MOF");
            throw new HSCCIMException("CIM_ERR_TYPE_MISMATCH");
        }
    }

    public Vector cimGetAssociatorNames(CIMOMHandle cIMOMHandle, int n) throws CIMException {
        int n2 = this.m_schema.getLinkedClassId(n);
        try {
            Vector vector = this.enumLinks(n);
            Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
            if (vector != null) {
                int n3 = 0;
                while (n3 < vector.size()) {
                    RObjectId rObjectId = (RObjectId)vector.elementAt(n3);
                    RObject rObject = rObjectId.getObject();
                    if (rObject != null) {
                        CIMObjectPath cIMObjectPath = rObject.cimGetCIMObjectPath(cIMOMHandle);
                        vector2.add(cIMObjectPath);
                    }
                    ++n3;
                }
            }
            return vector2;
        }
        catch (RException rException) {
            throw new HSCCIMException(rException.getID());
        }
    }

    public Vector cimGetAssociators(CIMOMHandle cIMOMHandle, int n) throws CIMException {
        int n2 = this.m_schema.getLinkedClassId(n);
        try {
            Vector vector = this.enumLinks(n);
            Vector<CIMInstance> vector2 = new Vector<CIMInstance>();
            if (vector != null) {
                int n3 = 0;
                while (n3 < vector.size()) {
                    RObjectId rObjectId = (RObjectId)vector.elementAt(n3);
                    RObject rObject = rObjectId.getObject();
                    if (rObject != null) {
                        CIMInstance cIMInstance = rObject.cimGetInstance(cIMOMHandle);
                        vector2.add(cIMInstance);
                    }
                    ++n3;
                }
            }
            return vector2;
        }
        catch (RException rException) {
            throw new HSCCIMException(rException.getID());
        }
    }

    public Vector cimGetReferenceNames(CIMOMHandle cIMOMHandle, int n) throws CIMException {
        return this.cimRefs(cIMOMHandle, n, 0);
    }

    public Vector cimGetReferences(CIMOMHandle cIMOMHandle, int n) throws CIMException {
        return this.cimRefs(cIMOMHandle, n, 1);
    }

    private Vector cimRefs(CIMOMHandle cIMOMHandle, int n, int n2) throws CIMException {
        int n3 = this.m_schema.getLinkedClassId(n);
        try {
            String string = RUtils.getNameSpaceString(this.m_nsid);
            Vector vector = this.enumLinks(n);
            Vector<RAssoKey> vector2 = new Vector<RAssoKey>();
            if (vector != null) {
                int n4 = 0;
                while (n4 < vector.size()) {
                    RObjectId rObjectId = (RObjectId)vector.elementAt(n4);
                    RObject rObject = rObjectId.getObject();
                    if (rObject != null) {
                        RAssoKey rAssoKey;
                        CIMObjectPath cIMObjectPath = rObject.cimGetCIMObjectPath(cIMOMHandle);
                        int n5 = this.m_schema.getAssoId(n);
                        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n5);
                        String string2 = rAssoSchema.getClassName();
                        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string2, string);
                        CIMInstance cIMInstance = cIMOMHandle.getClass(cIMObjectPath2, false).newInstance();
                        String string3 = null;
                        String string4 = null;
                        if (n == rAssoSchema.getRef1LinkId()) {
                            string4 = rAssoSchema.getRef1PropName();
                            string3 = rAssoSchema.getRef2PropName();
                        } else if (n == rAssoSchema.getRef2LinkId()) {
                            string4 = rAssoSchema.getRef2PropName();
                            string3 = rAssoSchema.getRef1PropName();
                        } else {
                            throw new HSCCIMException("Association Error");
                        }
                        cIMInstance.setProperty(string3, new CIMValue((Object)cIMObjectPath));
                        CIMObjectPath cIMObjectPath3 = this.cimGetCIMObjectPath(cIMOMHandle);
                        cIMInstance.setProperty(string4, new CIMValue((Object)cIMObjectPath3));
                        if (rAssoSchema.hasProperty()) {
                            rAssoKey = new RAssoKey(this.m_nsid, n5);
                            if (n == rAssoSchema.getRef1LinkId()) {
                                rAssoKey.setRef1ObjectId(this.getObjectId());
                                rAssoKey.setRef2ObjectId(rObjectId);
                            } else if (n == rAssoSchema.getRef2LinkId()) {
                                rAssoKey.setRef1ObjectId(rObjectId);
                                rAssoKey.setRef2ObjectId(this.getObjectId());
                            } else {
                                System.out.println("[TX-REP]It must be a bug. An association with one or more regular properties might not be defined well. ");
                                throw new HSCCIMException("CIM_ERR_FAILED");
                            }
                            Hashtable hashtable = rAssoSchema.getAssoPropHash();
                            Hashtable hashtable2 = RAssoSchema.getAssoObjHash();
                            Hashtable hashtable3 = (Hashtable)hashtable2.get(rAssoKey);
                            Enumeration enumeration = hashtable.keys();
                            while (enumeration.hasMoreElements()) {
                                String string5 = (String)enumeration.nextElement();
                                CIMDataType cIMDataType = (CIMDataType)hashtable.get(string5);
                                Object var27_28 = null;
                                if (hashtable3 != null) {
                                    var27_28 = hashtable3.get(string5);
                                }
                                Object object = RCimWrapper.getCValue(cIMDataType, var27_28, string5);
                                CIMValue cIMValue = null;
                                if (object != null) {
                                    cIMValue = new CIMValue(object, cIMDataType);
                                }
                                cIMInstance.setProperty(string5, cIMValue);
                            }
                        }
                        rAssoKey = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                        rAssoKey.setNameSpace(string);
                        if (n2 == 0) {
                            vector2.add(rAssoKey);
                        } else {
                            vector2.add((RAssoKey)cIMInstance);
                        }
                    }
                    ++n4;
                }
            }
            return vector2;
        }
        catch (RException rException) {
            throw new HSCCIMException(rException.getID());
        }
    }

    public Vector referencesByLink(int n) throws RException {
        int n2 = this.m_schema.getAssoId(n);
        int n3 = this.m_schema.getLinkedClassId(n);
        String string = RUtils.getNameSpaceString(this.m_nsid);
        Vector vector = this.enumLinks(n);
        Vector<RAssoObject> vector2 = new Vector<RAssoObject>();
        if (vector != null) {
            int n4 = 0;
            while (n4 < vector.size()) {
                RObjectId rObjectId = (RObjectId)vector.elementAt(n4);
                RObject rObject = rObjectId.getObject();
                if (rObject != null) {
                    RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n2);
                    String string2 = rAssoSchema.getClassName();
                    RAssoKey rAssoKey = new RAssoKey(this.m_nsid, n2);
                    if (rObjectId.getClassId() == rAssoSchema.getRef1ClassId()) {
                        rAssoKey.setRef1ObjectId(rObjectId);
                        rAssoKey.setRef2ObjectId(this.getObjectId());
                    } else if (rObjectId.getClassId() == rAssoSchema.getRef2ClassId()) {
                        rAssoKey.setRef1ObjectId(this.getObjectId());
                        rAssoKey.setRef2ObjectId(rObjectId);
                    } else {
                        throw new RException("Association Error");
                    }
                    RAssoObject rAssoObject = new RAssoObject(rAssoKey);
                    if (rAssoSchema.hasProperty()) {
                        Hashtable hashtable = rAssoSchema.getAssoPropHash();
                        Hashtable hashtable2 = RAssoSchema.getAssoObjHash();
                        Hashtable hashtable3 = (Hashtable)hashtable2.get(rAssoKey);
                        Enumeration enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            String string3 = (String)enumeration.nextElement();
                            CIMDataType cIMDataType = (CIMDataType)hashtable.get(string3);
                            Object var20_20 = null;
                            if (hashtable3 != null) {
                                var20_20 = hashtable3.get(string3);
                            }
                            rAssoObject.setProperty(string3, var20_20);
                        }
                    }
                    vector2.add(rAssoObject);
                }
                ++n4;
            }
        }
        return vector2;
    }

    public Vector deleteAssociated(int n) throws RException {
        Vector vector = this.associatorNames(n);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                RObjectId rObjectId = (RObjectId)enumeration.nextElement();
                RObject rObject = rObjectId.getObject();
                if (rObject == null) continue;
                rObject.deleteInstance();
            }
        }
        return vector;
    }

    public Vector deleteAssociatedByLink(int n) throws RException {
        Vector vector = this.associatorNamesByLink(n);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                RObjectId rObjectId = (RObjectId)enumeration.nextElement();
                RObject rObject = rObjectId.getObject();
                if (rObject == null) continue;
                rObject.deleteInstance();
            }
        }
        return vector;
    }

    public void deleteAssociations(int n) throws RException {
        int n2 = this.getLinkId(n);
        int n3 = this.m_schema.getLinkBase();
        int n4 = this.m_schema.getNumOfLinks();
        if (n2 < n3 || n2 >= n3 + n4) {
            System.out.println("[TX-REP]linkId=" + n2);
            System.out.println("[TX-REP]linkBase=" + n3);
            System.out.println("[TX-REP]numOfLinks=" + n4);
            throw new RException("R_ERR_NOT_FOUND");
        }
        Vector vector = this.m_link[n2 - n3];
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                RObjectId rObjectId = (RObjectId)iterator.next();
                RObject rObject = rObjectId.getObject();
                if (rObject != null) {
                    int n5 = rObject.getLinkId(n);
                    rObject.removeLink(n5, this.getObjectId());
                }
                iterator.remove();
            }
        }
    }

    public void deleteAssociationsByLink(int n) throws RException {
        int n2 = this.m_schema.getAssoId(n);
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n2);
        int n3 = rAssoSchema.getRef1LinkId();
        int n4 = rAssoSchema.getRef2LinkId();
        int n5 = -1;
        if (n == n3) {
            n5 = n4;
        } else if (n == n4) {
            n5 = n3;
        } else {
            throw new RException("R_ERR_FAILED");
        }
        int n6 = this.m_schema.getLinkBase();
        int n7 = this.m_schema.getNumOfLinks();
        if (n < n6 || n >= n6 + n7) {
            System.out.println("[TX-REP]linkId=" + n);
            System.out.println("[TX-REP]linkBase=" + n6);
            System.out.println("[TX-REP]numOfLinks=" + n7);
            throw new RException("R_ERR_NOT_FOUND");
        }
        Vector vector = this.m_link[n - n6];
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                RObjectId rObjectId = (RObjectId)iterator.next();
                RObject rObject = rObjectId.getObject();
                if (rObject != null) {
                    rObject.removeLink(n5, this.getObjectId());
                }
                iterator.remove();
            }
        }
    }
}

